﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VIMT.VIAEMRService;
using VIMT.VIAEMRService.Messages;
using VIMT.VIASchedulingService.Messages;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.Links;
using System.Diagnostics;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupMakeAppointment
{
    public class SendBothLoginsToEcStep:FilterBase<MakeGroupAppointmentStateObject>
    {
        public override void Execute(MakeGroupAppointmentStateObject state)
        {
            if (!string.IsNullOrEmpty(state.ProUserDuz) && !string.IsNullOrEmpty(state.PatUserDuz))
                return;
            else if (state.ProEcRequest == null && !string.IsNullOrEmpty(state.PatUserDuz))
                return;
            else if (state.PatEcRequest == null && !string.IsNullOrEmpty(state.ProUserDuz))
                return;

            if (!string.IsNullOrEmpty(state.VistaFakeResponseType))
            {
                if (state.ProEcRequest != null)
                    state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = string.IsNullOrEmpty(state.ProUserDuz) ? "FAKE_ProviderLogin" : state.ProUserDuz;
                if (state.PatEcRequest != null)
                    state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = string.IsNullOrEmpty(state.PatUserDuz) ? "FAKE_PatientLogin" : state.PatUserDuz;
                return;
            }

            LoginRequest patLogin = new LoginRequest
            {
                side = Side.Patient
            };
            LoginRequest proLogin = new LoginRequest
            {
                side = Side.Provider
            };

            if (string.IsNullOrEmpty(state.ProUserDuz))
                proLogin.Request = state.ProLoginRequest;
            else
                proLogin.userId = state.ProUserDuz;

            if (string.IsNullOrEmpty(state.PatUserDuz))
                patLogin.Request = state.PatLoginRequest;
            else
                patLogin.userId = state.PatUserDuz;

            var timer = new Stopwatch();
            timer.Start();
            Parallel.ForEach(new LoginRequest[] { patLogin, proLogin }, login =>
            {
                if (login.Request != null)
                    login.userId = VistaMapperHelper.GetViaLoginId(login.Request, login.side);
            });
            timer.Stop();
            state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;

            state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = proLogin.userId;
            state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = patLogin.userId;
        }
    }
}
